/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.Macros;
import org.openvpms.macro.impl.AbstractMacros;
import org.openvpms.macro.impl.ExpressionMacro;
import org.openvpms.macro.impl.ExpressionMacroRunner;
import org.openvpms.macro.impl.Macro;
import org.openvpms.macro.impl.MacroContext;
import org.openvpms.macro.impl.MacroFactory;
import org.openvpms.web.component.bound.AbstractBoundFieldTest;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.StringPropertyTransformer;
import org.openvpms.web.echo.text.TextComponent;

public abstract class AbstractBoundTextComponentTest
extends AbstractBoundFieldTest<TextComponent, String> {
    AbstractBoundTextComponentTest() {
        super("value1", "value2");
    }

    AbstractBoundTextComponentTest(String value1, String value2) {
        super(value1, value2);
    }

    @Override
    protected String getValue(TextComponent field) {
        return field.getText();
    }

    @Override
    protected void setValue(TextComponent field, String value) {
        field.setText(value);
    }

    @Override
    protected Property createProperty() {
        return new SimpleProperty("String", String.class);
    }

    void checkSingleMacroExpansion() {
        this.checkMacroExpansion("@short", 0, "a", 1);
        this.checkMacroExpansion("@short 1", 0, "a 1", 1);
        this.checkMacroExpansion("1 @short 2", 2, "1 a 2", 3);
        this.checkMacroExpansion("3 @short 4", 3, "3 a 4", 3);
        this.checkMacroExpansion("@same", 0, "12345", 5);
        this.checkMacroExpansion("@same 1", 0, "12345 1", 5);
        this.checkMacroExpansion("1 @same 2", 2, "1 12345 2", 7);
        this.checkMacroExpansion("3 @same 4", 3, "3 12345 4", 7);
        this.checkMacroExpansion("@long", 0, "abcdef", 6);
        this.checkMacroExpansion("@long 1", 0, "abcdef 1", 6);
        this.checkMacroExpansion("1 @long 2", 2, "1 abcdef 2", 8);
        this.checkMacroExpansion("3 @long 4", 3, "3 abcdef 4", 8);
        this.checkMacroExpansion("1 @short 2", 0, "1 a 2", 0);
        this.checkMacroExpansion("1 @short 2", 1, "1 a 2", 1);
        this.checkMacroExpansion("1 @same 2", 0, "1 12345 2", 0);
        this.checkMacroExpansion("1 @same 2", 1, "1 12345 2", 1);
        this.checkMacroExpansion("1 @long 2", 0, "1 abcdef 2", 0);
        this.checkMacroExpansion("1 @long 2", 1, "1 abcdef 2", 1);
        this.checkMacroExpansion("1 @short 2", 8, "1 a 2", 3);
        this.checkMacroExpansion("1 @short 2", 9, "1 a 2", 4);
        this.checkMacroExpansion("1 @same 2", 7, "1 12345 2", 7);
        this.checkMacroExpansion("1 @same 2", 8, "1 12345 2", 8);
        this.checkMacroExpansion("1 @long 2", 7, "1 abcdef 2", 8);
        this.checkMacroExpansion("1 @long 2", 8, "1 abcdef 2", 9);
    }

    private void checkMacroExpansion(String inputText, int inputPosition, String expandedText, int newPosition) {
        this.checkMacroExpansion(inputText, inputPosition, expandedText, newPosition, false);
        this.checkMacroExpansion(inputText, inputPosition, expandedText, newPosition, true);
    }

    private void checkMacroExpansion(String inputText, int inputPosition, String expandedText, int newPosition, boolean cursorBeforeText) {
        Property property = this.createProperty();
        TestMacros macros = new TestMacros();
        TextComponent component = (TextComponent)this.createField(property);
        AtomicInteger count = new AtomicInteger();
        component.addPropertyChangeListener("text", evt -> count.incrementAndGet());
        property.setTransformer((PropertyTransformer)new StringPropertyTransformer(property, (Macros)macros));
        if (cursorBeforeText) {
            component.processInput("cursorPosition", (Object)inputPosition);
        }
        component.processInput("text", (Object)inputText);
        if (!cursorBeforeText) {
            component.processInput("cursorPosition", (Object)inputPosition);
        }
        Assert.assertEquals((Object)expandedText, (Object)component.getText());
        Assert.assertEquals((long)newPosition, (long)component.getCursorPosition());
        Assert.assertEquals((long)2L, (long)count.get());
    }

    private static class TestMacros
    extends AbstractMacros {
        private final MacroFactory factory = (MacroFactory)Mockito.mock(MacroFactory.class);

        TestMacros() {
            Mockito.when((Object)this.factory.create((Macro)Matchers.any(), (MacroContext)Matchers.any())).thenAnswer(invocationOnMock -> new ExpressionMacroRunner((MacroContext)invocationOnMock.getArguments()[1]));
            this.add((Macro)new ExpressionMacro("@short", "short macro", "'a'"));
            this.add((Macro)new ExpressionMacro("@long", "long macro", "'abcdef'"));
            this.add((Macro)new ExpressionMacro("@same", "same macro", "'12345'"));
        }

        protected MacroContext createMacroContext(Map<String, Macro> macros, Object object, Variables variables) {
            return new MacroContext(macros, this.factory, object, variables, null);
        }
    }
}

