/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Window;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.test.AbstractAppTest;

public abstract class AbstractBoundFieldTest<T, V>
extends AbstractAppTest {
    private final V value1;
    private final V value2;

    public AbstractBoundFieldTest(V value1, V value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    @Test
    public void testPropertyUpdate() {
        Property property = this.createProperty();
        T field = this.createField(property);
        property.setValue(this.value1);
        Assert.assertEquals(this.value1, this.getValue(field));
        property.setValue(this.value2);
        Assert.assertEquals(this.value2, this.getValue(field));
    }

    @Test
    public void testFieldUpdate() {
        Property property = this.createProperty();
        T field = this.createField(property);
        this.setValue(field, this.value1);
        Assert.assertEquals(this.value1, this.getValue(property));
        this.setValue(field, this.value2);
        Assert.assertEquals(this.value2, this.getValue(property));
    }

    @Test
    public void testInitDispose() {
        Window window = ApplicationInstance.getActive().getDefaultWindow();
        ContentPane container = window.getContent();
        Property property = this.createProperty();
        T field = this.createField(property);
        property.setValue(this.value2);
        Assert.assertEquals(this.value2, this.getValue(field));
        this.addComponent((Component)container, field);
        property.setValue(this.value1);
        Assert.assertEquals(this.value1, this.getValue(field));
        this.removeComponent((Component)container, field);
        property.setValue(this.value2);
        Assert.assertNotEquals(this.value2, this.getValue(field));
        this.addComponent((Component)container, field);
        Assert.assertEquals(this.value2, this.getValue(field));
        property.setValue(this.value1);
        Assert.assertEquals(this.value1, this.getValue(field));
    }

    protected abstract V getValue(T var1);

    protected V getValue(Property property) {
        return (V)property.getValue();
    }

    protected abstract void setValue(T var1, V var2);

    protected abstract T createField(Property var1);

    protected abstract Property createProperty();

    protected void addComponent(Component container, T field) {
        container.add((Component)field);
    }

    protected void removeComponent(Component container, T field) {
        container.remove((Component)field);
    }
}

