/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.component.im.print;

import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.ArchetypeServiceException;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.report.IMReport;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReporterFactory;


/**
 * Prints reports for {@link ObjectSet}s generated by {@link IMReport}.
 *
 * @author Tim Anderson
 */
public class ObjectSetReportPrinter extends TemplatedIMPrinter<ObjectSet> {

    /**
     * Constructs an {@link ObjectSetReportPrinter}.
     *
     * @param set            the set to print
     * @param template       the document template to use
     * @param printerContext the printer context
     * @param context        the context
     * @param factory        the reporter factory
     * @throws ArchetypeServiceException for any archetype service error
     */
    public ObjectSetReportPrinter(Iterable<ObjectSet> set, DocumentTemplate template, PrinterContext printerContext,
                                  Context context, ReporterFactory factory) {
        super(factory.createObjectSetReporter(set, template), printerContext, context);
    }

    /**
     * Constructs an {@link ObjectSetReportPrinter}.
     *
     * @param set            the set to print
     * @param locator        the document template locator
     * @param printerContext the printer context
     * @param context        the context
     * @param factory        the reporter factory
     * @throws ArchetypeServiceException for any archetype service error
     */
    public ObjectSetReportPrinter(Iterable<ObjectSet> set, DocumentTemplateLocator locator,
                                  PrinterContext printerContext, Context context, ReporterFactory factory) {
        super(factory.createObjectSetReporter(set, locator), printerContext, context);
    }

    /**
     * Constructs a {@link ObjectSetReportPrinter}.
     *
     * @param set            the set to print
     * @param shortName      the archetype short name to determine the template to use
     * @param printerContext the printer context
     * @param context        the context
     * @param factory        the reporter factory
     * @throws ArchetypeServiceException for any archetype service error
     */
    public ObjectSetReportPrinter(Iterable<ObjectSet> set, String shortName, PrinterContext printerContext,
                                  Context context, ReporterFactory factory) {
        this(set, new ContextDocumentTemplateLocator(shortName, context), printerContext, context, factory);
    }

}
