/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.component.im.lookup;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.property.Property;

/**
 * An editor for lookup properties that uses a {@link LookupField} to display the lookups.
 *
 * @author Tim Anderson
 */
public class DefaultLookupPropertyEditor extends PropertyComponentEditor implements LookupPropertyEditor {

    /**
     * Constructs a {@link DefaultLookupPropertyEditor}.
     *
     * @param property the property being edited
     * @param parent   the parent object
     */
    public DefaultLookupPropertyEditor(Property property, IMObject parent) {
        this(property, LookupFieldFactory.create(property, parent));
    }

    /**
     * Constructs a {@link DefaultLookupPropertyEditor}.
     *
     * @param property  the property being edited
     * @param component the edit component
     */
    public DefaultLookupPropertyEditor(Property property, LookupField component) {
        super(property, component);
    }

    /**
     * Refreshes the set of available lookups.
     */
    @Override
    public void refresh() {
        ((LookupField) getComponent()).refresh();
    }
}
