/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.war;

import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.tool.toolbox.AbstractCommand;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.util.PathHelper;
import org.openvpms.tool.toolbox.war.WarBuilder;
import picocli.CommandLine;

@CommandLine.Command(name="war", header={"Create the web archive"})
public class WarCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-n", "--name"}, description={"The war file name"}, defaultValue="openvpms.war")
    String name;
    @CommandLine.Option(names={"-a", "--archive"}, description={"The archive path"}, defaultValue="${openvpms.home}/webapps/openvpms-master.zip")
    String archive;
    @CommandLine.Option(names={"-d", "--dir"}, required=true, description={"Output directory"}, defaultValue="${openvpms.home}/webapps")
    String dir;

    @Override
    protected void init() throws Exception {
        ConfigProperties properties = this.loadProperties();
        this.checkProperties(properties);
    }

    @Override
    protected int run() throws Exception {
        int result = 1;
        String war = this.getWarName();
        if (war != null) {
            WarBuilder builder = new WarBuilder();
            Path target = builder.build(war, this.dir, this.archive, this.getPropertiesPath());
            Path relative = PathHelper.getPathRelativeToCWD(target);
            System.out.printf("Created %s\n\n", relative);
            try {
                PathHelper.restrictPermissions(target);
            }
            catch (Throwable exception) {
                System.err.printf("\nThe file %s should have restrictive permissions to protect passwords\n\n", relative);
            }
            result = 0;
        }
        return result;
    }

    private String getWarName() {
        String result = null;
        if (this.name != null) {
            String war = StringUtils.removeEndIgnoreCase((String)this.name, (String)".war");
            if (!war.matches("[a-zA-Z]+[a-zA-Z0-9_\\-]*")) {
                System.err.printf("%s is not a valid name\n", this.name);
            } else {
                result = war;
            }
        } else {
            result = "openvpms";
        }
        return result;
    }
}

