/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.user;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.openvpms.tool.toolbox.user.AbstractUserCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--force-change-password", description={"Force users to change passwords on next login"})
public class ChangePasswordCommand
extends AbstractUserCommand {
    @CommandLine.ArgGroup(multiplicity="1")
    Type type;

    @Override
    protected int run() {
        int result;
        if (this.type.user != null) {
            User user = this.getUser(this.type.user);
            if (user != null) {
                if (!user.getChangePassword()) {
                    user.setChangePassword(true);
                    this.save(user);
                }
                result = 0;
                System.out.println("User updated");
            } else {
                result = 1;
                System.err.println("User not found");
            }
        } else if (this.type.all) {
            ArchetypeService service = (ArchetypeService)this.getBean(IArchetypeRuleService.class);
            CriteriaBuilder builder = service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(User.class);
            Root from = query.from(User.class, new String[]{"security.user"});
            query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
            TypedQueryIterator iterator = new TypedQueryIterator(service.createQuery(query), 100);
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                if (user.getChangePassword()) continue;
                user.setChangePassword(true);
                this.save(user);
            }
            System.out.println("Users updated");
            result = 0;
        } else {
            result = 1;
            System.err.println("One of --all or --user must be specified");
        }
        return result;
    }

    static class Type {
        @CommandLine.Option(names={"-u", "--user"}, description={"Force password change for the specified user"})
        private String user;
        @CommandLine.Option(names={"-a", "--all"}, description={"Force password change for all users"})
        private boolean all;

        Type() {
        }
    }
}

