/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.plugin;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.tool.toolbox.AbstractApplicationContextCommand;
import org.openvpms.tool.toolbox.plugin.PluginArtifactHelper;
import picocli.CommandLine;

@CommandLine.Command(name="--install", description={"Installs a plugin"})
public class InstallPluginCommand
extends AbstractApplicationContextCommand {
    @CommandLine.Parameters(description={"the .jar file"}, index="0", arity="1")
    File file;

    @Override
    protected int run() throws Exception {
        int result = 1;
        JarPluginArtifact artifact = new JarPluginArtifact(this.file);
        if (artifact.containsJavaExecutableCode()) {
            String key = PluginArtifactHelper.getPluginKey((PluginArtifact)artifact);
            if (key != null) {
                PluginDAO dao = this.getBean(PluginDAO.class);
                try (FileInputStream stream = new FileInputStream(this.file);){
                    dao.save(key, this.file.getName(), (InputStream)stream);
                    System.out.printf("Installed plugin with key %s\n", key);
                    result = 0;
                }
            }
        } else {
            System.err.printf("%s is not a recognised plugin\n", this.file.getName());
        }
        return result;
    }
}

