/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.plugin;

import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.tool.toolbox.AbstractApplicationContextCommand;

abstract class AbstractConfigurePluginCommand
extends AbstractApplicationContextCommand {
    private static final String ENABLE_PLUGINS = "enablePlugins";

    AbstractConfigurePluginCommand() {
    }

    protected int enable(boolean enable) {
        int result = 1;
        IMObjectBean practice = this.getPractice();
        if (practice != null) {
            if (practice.getBoolean(ENABLE_PLUGINS) != enable) {
                practice.setValue(ENABLE_PLUGINS, (Object)enable);
                practice.save();
                if (enable) {
                    System.out.println("Plugins enabled. If OpenVPMS is already running it needs to be restarted.");
                } else {
                    System.out.println("Plugins disabled. If OpenVPMS is already running it needs to be restarted.");
                }
            } else if (enable) {
                System.out.println("Plugins already enabled.");
            } else {
                System.out.println("Plugins already disabled.");
            }
            result = 0;
        } else {
            System.out.println("No practice found.");
        }
        return result;
    }

    protected IMObjectBean getPractice() {
        IArchetypeRuleService service = this.getBean(IArchetypeRuleService.class);
        Party practice = PracticeRules.getPractice((ArchetypeService)service);
        return practice != null ? service.getBean((IMObject)practice) : null;
    }
}

