/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import org.openvpms.db.service.DatabaseService;
import org.openvpms.tool.toolbox.db.AbstractDBCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="--version", header={"Displays the database version"})
public class DBVersionCommand
extends AbstractDBCommand {
    private static final Logger log = LoggerFactory.getLogger(DBVersionCommand.class);

    @Override
    protected int run() {
        DatabaseService service = this.getDatabaseService();
        String version = service.getVersion();
        if (version == null) {
            log.info("Database '{}' has no version information", (Object)service.getSchemaName());
        } else {
            log.info("Database '{}' is at version {}", (Object)service.getSchemaName(), (Object)version);
        }
        return 0;
    }
}

