/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import java.util.Properties;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ContextLoader {
    private final String username;
    private final String password;
    private final String driver;
    private final String url;
    private ClassPathXmlApplicationContext context;

    public ContextLoader(ConfigProperties properties) {
        this(properties.getDriver(), properties.getUrl(), properties.getUsername(), properties.getPassword());
    }

    public ContextLoader(String driver, String url, String username, String password) {
        this.username = username;
        this.password = password;
        this.driver = driver;
        this.url = url;
    }

    public ApplicationContext getContext() {
        if (this.context == null) {
            this.loadContext();
        }
        return this.context;
    }

    private void loadContext() {
        this.context = new ClassPathXmlApplicationContext();
        PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
        Properties properties = new Properties();
        properties.setProperty("db.username", this.username);
        properties.setProperty("db.password", this.password);
        properties.setProperty("db.driver", this.driver);
        properties.setProperty("db.url", this.url);
        configurer.setProperties(properties);
        this.context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
        this.context.setConfigLocation("toolbox-context.xml");
        this.context.refresh();
    }
}

