/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.archetype;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.tool.toolbox.AbstractApplicationContextCommand;
import org.openvpms.tools.archetype.diff.ArchDiff;
import org.openvpms.tools.archetype.io.DescriptorLoader;
import picocli.CommandLine;

@CommandLine.Command(name="--diff", description={"Compare archetypes"}, footer={"\n\nThe version1 and version2 arguments specify the older and newer versions of archetypes.\nThey may be:\n. an .adl file\n. a directory. All .adl files in the directory will be read.\n. database (or db) - all archetypes in the database will be read\n\nExamples:\n1. Compare a directory with archetypes in the database\n> toolbox archetype --diff -v ../archetypes\n\n2. Compare a file with a prior version in the database\n> toolbox archetype --diff -v db ../archetypes/contact.location.adl\n\n3. Compare two directories containing archetypes\n> toolbox archetype --diff 2.1/archetypes 2.2/archetypes\n\n"})
public class ArchetypeDiffCommand
extends AbstractApplicationContextCommand {
    @CommandLine.Parameters(index="0", description={"The first version to compare."}, arity="1")
    String version1;
    @CommandLine.Parameters(index="1", description={"The second version to compare."}, arity="1")
    String version2;
    @CommandLine.Option(names={"--no-recurse", "-n"}, description={"Disable search of subdirectories."})
    boolean norecurse;
    @CommandLine.Option(names={"--verbose", "-v"}, description={"Displays verbose info to the console."})
    boolean verbose;

    public ArchetypeDiffCommand() {
        super(true);
    }

    @Override
    protected int run() throws Exception {
        ArchDiff diff = new ArchDiff((IArchetypeService)this.getBean(IArchetypeRuleService.class));
        boolean recurse = !this.norecurse;
        DescriptorLoader oldVersion = diff.getDescriptorLoader(this.version1, recurse);
        DescriptorLoader newVersion = diff.getDescriptorLoader(this.version2, recurse);
        diff.compare(oldVersion, newVersion, this.verbose);
        return 0;
    }
}

