/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.user;

import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.openvpms.tool.toolbox.AbstractApplicationContextCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--list", description={"List users"})
public class ListUsersCommand
extends AbstractApplicationContextCommand {
    private static final String FORMAT = "%10s %-16s %-24s %-6s %-24s %-8s %s\n";

    @Override
    protected int run() throws Exception {
        Contacts contacts = new Contacts((ArchetypeService)this.getBean(IArchetypeRuleService.class));
        Iterator<User> iterator = this.getUsers();
        System.out.printf(FORMAT, "id", "username", "name", "active", "email", "connect", "roles");
        System.out.printf(FORMAT, "", "", "", "", "", "from", "");
        System.out.printf(FORMAT, "", "", "", "", "", "anywhere", "");
        System.out.println(StringUtils.repeat((char)'-', (int)108));
        while (iterator.hasNext()) {
            User user = iterator.next();
            this.write(user, contacts);
        }
        return 0;
    }

    private Iterator<User> getUsers() {
        ArchetypeService service = (ArchetypeService)this.getBean(IArchetypeRuleService.class);
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(User.class);
        Root from = query.from(User.class, new String[]{"security.user"});
        query.orderBy(new Order[]{builder.asc((Expression)from.get("username"))});
        return new TypedQueryIterator(service.createQuery(query), 100);
    }

    private void write(User user, Contacts contacts) {
        IMObjectBean bean = this.getBean(IArchetypeRuleService.class).getBean((org.openvpms.component.model.object.IMObject)user);
        String email = contacts.getEmail((Party)user);
        if (email == null) {
            email = "";
        }
        boolean connectFromAnywhere = bean.getBoolean("connectFromAnywhere");
        System.out.printf(FORMAT, user.getId(), user.getUsername(), user.getName(), user.isActive(), email, connectFromAnywhere, this.getRoles(user));
    }

    private String getRoles(User user) {
        Comparator comparator = (o1, o2) -> StringUtils.compare((String)o1.getName(), (String)o2.getName());
        return user.getRoles().stream().sorted(comparator).map(IMObject::getName).collect(Collectors.joining(", "));
    }
}

