/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.user;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.tool.toolbox.user.AbstractUserCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--connect-from-anywhere", description={"Sets the 'Connect From Anywhere' flag for users"})
public class ConnectFromAnywhereCommand
extends AbstractUserCommand {
    @CommandLine.ArgGroup(multiplicity="1")
    Action enableOrDisable;
    @CommandLine.Parameters(description={"The usernames of the users to update"}, arity="1..*")
    private String[] usernames;
    private static final String CONNECT_FROM_ANYWHERE = "connectFromAnywhere";

    @Override
    protected int run() {
        int result;
        ArchetypeService service = (ArchetypeService)this.getBean(IArchetypeRuleService.class);
        List<User> users = this.getUsers();
        if (users != null) {
            for (User user : users) {
                IMObjectBean bean = service.getBean((IMObject)user);
                if (bean.getBoolean(CONNECT_FROM_ANYWHERE) != this.enableOrDisable.enable) {
                    bean.setValue(CONNECT_FROM_ANYWHERE, (Object)this.enableOrDisable.enable);
                    bean.save();
                    System.out.println("User " + user.getUsername() + " updated");
                    continue;
                }
                System.out.println("No update required for " + user.getUsername());
            }
            result = 0;
        } else {
            result = 1;
        }
        return result;
    }

    private List<User> getUsers() {
        ArrayList<User> result = new ArrayList<User>();
        for (String username : this.usernames) {
            User user = this.getUser(username);
            if (user == null) {
                System.err.println("User " + username + " not found");
                result = null;
                break;
            }
            result.add(user);
        }
        return result;
    }

    static class Action {
        @CommandLine.Option(names={"--enable"}, description={"Allows users to connect from anywhere"})
        private boolean enable;
        @CommandLine.Option(names={"--disable"}, description={"Prevents users from connecting from anywhere"})
        private boolean disable;

        Action() {
        }
    }
}

