/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.tool.toolbox.user.AbstractRoleCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--add-role", description={"Adds roles to a user"})
public class AddRoleCommand
extends AbstractRoleCommand {
    @CommandLine.Parameters(description={"The roles to add"}, index="1..*", arity="1..*")
    String[] roles;

    @Override
    protected int updateUser(User user) {
        int result;
        int added = 0;
        List<SecurityRole> newRoles = this.getRoles(this.roles);
        if (!newRoles.isEmpty()) {
            for (SecurityRole newRole : newRoles) {
                if (!user.getRoles().contains(newRole)) {
                    user.addRole(newRole);
                    ++added;
                    continue;
                }
                System.out.println("User already has role: " + newRole.getName());
            }
            if (added != 0) {
                this.save(user);
                System.out.println("User updated");
            }
            result = 0;
        } else {
            result = 1;
        }
        return result;
    }

    protected List<SecurityRole> getRoles(String[] names) {
        ArrayList<SecurityRole> result = new ArrayList<SecurityRole>();
        for (String name : names) {
            SecurityRole role = this.getRole(name);
            if (role == null) {
                System.err.println("Role not found: " + name);
                return Collections.emptyList();
            }
            result.add(role);
        }
        return result;
    }

    private SecurityRole getRole(String name) {
        ArchetypeService service = (ArchetypeService)this.getBean(IArchetypeRuleService.class);
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(SecurityRole.class);
        Root from = query.from(SecurityRole.class, new String[]{"security.role"});
        query.where((Expression)builder.equal((Expression)from.get("name"), (Object)name));
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        return (SecurityRole)service.createQuery(query).getFirstResult();
    }
}

