/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.firewall;

import java.util.List;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.tool.toolbox.firewall.AbstractFirewallCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--list", description={"List allowed addresses that users can connect from"})
public class ListAllowedCommand
extends AbstractFirewallCommand {
    public static void showAllowedAddresses(FirewallSettings settings) {
        List allowed = settings.getAllowedAddresses();
        if (allowed.isEmpty()) {
            System.err.println("No allowed addresses configured");
        } else {
            int width = allowed.stream().mapToInt(value -> value.getAddress().length()).max().orElse(20);
            String format = "%-" + width + "s %-6s %s\n";
            System.out.printf(format, "Address", "Active", "Description");
            for (FirewallEntry entry : allowed) {
                System.out.printf(format, entry.getAddress(), Character.valueOf(entry.isActive() ? (char)'Y' : 'N'), entry.getDescription() != null ? entry.getDescription() : "");
            }
        }
    }

    @Override
    protected int run() throws Exception {
        FirewallSettings settings = this.getSettings();
        ListAllowedCommand.showAllowedAddresses(settings);
        return 0;
    }
}

