/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.firewall;

import java.util.List;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.tool.toolbox.firewall.AbstractFirewallCommand;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import picocli.CommandLine;

@CommandLine.Command(name="--add", description={"Add allowed address"})
public class AddAllowedCommmand
extends AbstractFirewallCommand {
    @CommandLine.Parameters(index="0", arity="1")
    String address;
    @CommandLine.Option(names={"-d"}, description={"address description"})
    private String description;

    @Override
    protected int run() throws Exception {
        FirewallSettings settings = this.getSettings();
        List allowed = settings.getAllowedAddresses();
        new IpAddressMatcher(this.address);
        allowed.removeIf(entry -> this.address.equals(entry.getAddress()));
        allowed.add(new FirewallEntry(this.address, true, this.description));
        settings.setAllowedAddresses(allowed);
        this.save(settings);
        return 0;
    }
}

