/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.firewall;

import java.util.List;
import java.util.ListIterator;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.tool.toolbox.AbstractApplicationContextCommand;

public abstract class AbstractFirewallCommand
extends AbstractApplicationContextCommand {
    protected FirewallSettings getSettings() {
        ArchetypeService service = (ArchetypeService)this.getBean(IArchetypeRuleService.class);
        SingletonService singletonService = this.getBean(SingletonService.class);
        Entity settings = (Entity)singletonService.get("entity.globalSettingsFirewall", Entity.class, true);
        return new FirewallSettings(settings, service);
    }

    protected boolean updateActive(String address, boolean active) {
        boolean updated = false;
        boolean found = false;
        FirewallSettings settings = this.getSettings();
        List allowed = settings.getAllowedAddresses();
        ListIterator<FirewallEntry> iterator = allowed.listIterator();
        while (iterator.hasNext()) {
            FirewallEntry entry = (FirewallEntry)iterator.next();
            if (!entry.getAddress().equals(address)) continue;
            found = true;
            if (active == entry.isActive()) continue;
            iterator.set(new FirewallEntry(address, active, entry.getDescription()));
            updated = true;
        }
        if (updated) {
            settings.setAllowedAddresses(allowed);
            this.save(settings);
            System.out.println("Firewall updated");
        } else if (!found) {
            System.err.println("Address not found");
        } else {
            System.err.println("No update required");
        }
        return found;
    }

    protected void save(FirewallSettings settings) {
        ArchetypeService service = (ArchetypeService)this.getBean(IArchetypeRuleService.class);
        service.save((IMObject)settings.getSettings());
    }
}

