/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import java.io.Console;
import org.openvpms.db.service.DatabaseAdminService;
import org.openvpms.db.service.DbVersionInfo;
import org.openvpms.tool.toolbox.db.AbstractAdminDBCommand;
import org.openvpms.tool.toolbox.i18n.ToolboxMessages;
import picocli.CommandLine;

@CommandLine.Command(name="--update", header={"Updates the database to the latest version"})
public class UpdateDBCommand
extends AbstractAdminDBCommand {
    @CommandLine.Option(names={"-d", "--dir"}, required=true, description={"The archetype directory."}, defaultValue="${openvpms.home}/archetypes")
    String dir = "${openvpms.home}/archetypes";
    @CommandLine.Option(names={"--plugins"}, required=true, description={"The plugins directory."}, defaultValue="${openvpms.home}/plugins")
    String pluginsDir = "${openvpms.home}/plugins";
    @CommandLine.Option(names={"--database-is-backed-up"}, hidden=true)
    boolean backedup;
    private static final String DEFAULT_PLUGINS_DIR = "${openvpms.home}/plugins";

    @Override
    protected int run() throws Exception {
        int result = 1;
        DatabaseAdminService service = this.getAdminService();
        DbVersionInfo versionInfo = service.getVersionInfo();
        if (versionInfo.hasFutureVersion()) {
            String error = ToolboxMessages.get("db.update.futurechanges", versionInfo.getFutureChanges());
            System.err.println(error);
        } else if (versionInfo.needsUpdate()) {
            this.dir = this.getDir(this.dir, "--dir");
            this.pluginsDir = this.getDir(this.pluginsDir, "--plugins");
            if (this.backedup(versionInfo.getChanges())) {
                this.updateDatabase(this.dir, this.pluginsDir);
                result = 0;
            }
        } else {
            System.out.println(ToolboxMessages.get("db.update.uptodate", new Object[0]));
            result = 0;
        }
        return result;
    }

    private boolean backedup(int changes) {
        boolean result = false;
        if (this.backedup) {
            result = true;
        } else {
            Console console = System.console();
            if (console == null) {
                System.err.println(ToolboxMessages.get("db.update.console", new Object[0]));
            } else {
                String input;
                console.printf(ToolboxMessages.get("db.update.changes", changes) + "\n\n", new Object[0]);
                console.printf(ToolboxMessages.get("db.update.warning", new Object[0]) + "\n\n", new Object[0]);
                do {
                    console.printf(ToolboxMessages.get("db.update.proceed", new Object[0]) + " ", new Object[0]);
                    input = console.readLine();
                    if (!"Y".equals(input)) continue;
                    result = true;
                    break;
                } while (!"n".equals(input));
            }
        }
        return result;
    }
}

