/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import java.sql.SQLException;
import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.DatabaseAdminService;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.db.AbstractAdminDBCommand;
import org.openvpms.tool.toolbox.i18n.ToolboxMessages;
import picocli.CommandLine;

@CommandLine.Command(name="--setup-users", header={"Sets up OpenVPMS database users"})
public class SetupUsersCommand
extends AbstractAdminDBCommand {
    @CommandLine.Option(names={"--host"}, description={"Host users are connecting from"}, required=true, defaultValue="localhost", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String host;

    @Override
    protected int run() throws SQLException {
        DatabaseAdminService service = this.getAdminService();
        ConfigProperties properties = this.getProperties();
        service.createUsers(new Credentials(properties.getUsername(), properties.getPassword()), new Credentials(properties.getReportingUsername(), properties.getReportingPassword()), this.host);
        System.out.println(ToolboxMessages.get("db.setupusers", properties.getUsername(), properties.getReportingUsername()));
        return 0;
    }
}

