/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.component.business.domain.im.plugin.Plugin;
import org.openvpms.db.service.PluginMigrator;
import org.openvpms.tool.toolbox.plugin.PluginArtifactHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginMigrator
implements PluginMigrator {
    private final PluginDAO dao;
    private final String dir;
    private static final Logger log = LoggerFactory.getLogger(AbstractPluginMigrator.class);

    public AbstractPluginMigrator(PluginDAO dao, String dir) {
        this.dao = dao;
        this.dir = dir;
    }

    protected void update() {
        Iterator<Plugin> plugins = this.getInstalledPlugins();
        if (plugins.hasNext()) {
            Map<String, JarPluginArtifact> availablePlugins = this.getAvailablePlugins();
            if (log.isDebugEnabled()) {
                String available = availablePlugins.entrySet().stream().map(entry -> "[key=" + (String)entry.getKey() + ", name=" + ((JarPluginArtifact)entry.getValue()).getName() + "]").collect(Collectors.joining(", "));
                log.debug("Available plugins: {}", (Object)available);
            }
            while (plugins.hasNext()) {
                Plugin plugin = plugins.next();
                String key = plugin.getKey();
                JarPluginArtifact artifact = availablePlugins.get(key);
                if (artifact != null) {
                    log.debug("Updating plugin [key={}, name={}] with {}", new Object[]{key, plugin.getName(), artifact.getName()});
                    this.save(key, artifact);
                    continue;
                }
                log.debug("Not updating plugin [key={}, name={}]. No plugin artifact available.", (Object)key, (Object)plugin.getName());
            }
        } else {
            log.debug("Not updating plugins, no plugins installed");
        }
    }

    protected void save(String key, JarPluginArtifact artifact) {
        try (InputStream stream = artifact.getInputStream();){
            this.dao.save(key, artifact.getName(), stream);
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to save plugin " + artifact.getName() + ": " + exception.getMessage(), exception);
        }
    }

    protected Map<String, JarPluginArtifact> getAvailablePlugins() {
        HashMap<String, JarPluginArtifact> result = new HashMap<String, JarPluginArtifact>();
        for (File file : FileUtils.listFiles((File)new File(this.dir), (String[])new String[]{"jar"}, (boolean)false)) {
            String key;
            JarPluginArtifact artifact = new JarPluginArtifact(file);
            if (!artifact.containsJavaExecutableCode() || (key = PluginArtifactHelper.getPluginKey((PluginArtifact)artifact)) == null) continue;
            result.put(key, artifact);
        }
        return result;
    }

    protected Iterator<Plugin> getInstalledPlugins() {
        return this.dao.getPlugins();
    }
}

