/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.config;

import java.io.Console;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.tool.toolbox.config.Config;
import org.openvpms.tool.toolbox.config.FallbackConfig;

class ConsoleConfig
implements Config {
    private final Console console;
    private final FallbackConfig config;
    private static final String DATABASE_URL = "Database URL";
    private static final String DATABASE_USER = "Database user";
    private static final String DATABASE_PASSWORD = "Database password";
    private static final String REPORTING_DATABASE_URL = "Reporting database URL";
    private static final String REPORTING_DATABASE_USER = "Reporting database user";
    private static final String REPORTING_DATABASE_PASSWORD = "Reporting database password";

    public ConsoleConfig(Console console, Properties properties, Properties defaults) {
        this.console = console;
        this.config = new FallbackConfig(properties, defaults);
    }

    @Override
    public String getDriver() {
        return this.config.getDriver();
    }

    @Override
    public String getUrl() {
        return this.prompt(DATABASE_URL, this.config.getUrl());
    }

    @Override
    public String getUsername() {
        return this.prompt(DATABASE_USER, this.config.getUsername());
    }

    @Override
    public String getPassword() {
        return this.prompt(DATABASE_PASSWORD, this.config.getPassword());
    }

    @Override
    public String getReportingUrl() {
        return this.prompt(REPORTING_DATABASE_URL, this.config.getReportingUrl());
    }

    @Override
    public String getReportingUsername() {
        String result = this.prompt(REPORTING_DATABASE_USER, this.config.getReportingUsername());
        while (StringUtils.equals((CharSequence)result, (CharSequence)this.config.getUsername())) {
            this.console.printf("ERROR: 'Reporting database user' must be different to 'Database user'\n", new Object[0]);
            result = this.prompt(REPORTING_DATABASE_USER, this.config.getReportingUsername());
        }
        return result;
    }

    @Override
    public String getReportingPassword() {
        return this.prompt(REPORTING_DATABASE_PASSWORD, this.config.getReportingPassword());
    }

    @Override
    public String getKey() {
        return this.config.getKey();
    }

    private String prompt(String prompt, String defaultValue) {
        String result = null;
        boolean done = false;
        while (!done) {
            String line = defaultValue != null ? prompt + " [" + defaultValue + "]: " : prompt + ": ";
            this.console.printf(line, new Object[0]);
            result = this.console.readLine();
            if (!StringUtils.isEmpty((CharSequence)result)) {
                done = true;
                continue;
            }
            if (defaultValue == null) continue;
            result = defaultValue;
            done = true;
        }
        return result;
    }
}

