/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.openvpms.tool.toolbox.config.AbstractConfigProperties;

public class ConfigProperties
extends AbstractConfigProperties {
    private final Path path;
    private static final String[] PROPERTIES = new String[]{"db.driver", "db.url", "db.username", "db.password", "reporting.db.url", "reporting.db.username", "reporting.db.password", "openvpms.key"};

    public ConfigProperties(Path path) throws IOException {
        this(path, true);
    }

    public ConfigProperties(Path path, boolean read) throws IOException {
        super(new OrderedProperties());
        this.path = path;
        if (read && this.exists()) {
            try (FileInputStream stream = new FileInputStream(path.toFile());){
                this.getProperties().load(stream);
            }
        }
    }

    public boolean isComplete() {
        for (String name : PROPERTIES) {
            if (this.get(name) != null) continue;
            return false;
        }
        return true;
    }

    public void validate() {
        for (String name : PROPERTIES) {
            this.checkRequired(name);
        }
        if (this.getUsername().equals(this.getReportingUsername())) {
            throw new IllegalStateException("db.username and reporting.db.username must be different users");
        }
    }

    public Path getPath() {
        return this.path;
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public void copy(ConfigProperties properties) {
        Properties source = properties.getProperties();
        for (String name : PROPERTIES) {
            this.set(name, source.getProperty(name));
        }
    }

    protected void checkRequired(String name) {
        if (this.get(name) == null) {
            throw new IllegalStateException("Property '" + name + "' missing from " + this.getPath());
        }
    }

    protected boolean set(String name, String value) {
        boolean result = false;
        Properties properties = this.getProperties();
        if (!Objects.equals(properties.get(name), value)) {
            result = true;
            if (value == null) {
                properties.remove(name);
            } else {
                properties.setProperty(name, value);
            }
        }
        return result;
    }

    private static class OrderedProperties
    extends Properties {
        private OrderedProperties() {
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keySet());
        }

        @Override
        public Set<Object> keySet() {
            LinkedHashSet<Object> keys = new LinkedHashSet<Object>(super.keySet());
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            block0: for (String key : PROPERTIES) {
                for (Object entry : keys.toArray()) {
                    if (!entry.equals(key)) continue;
                    result.add(entry);
                    keys.remove(entry);
                    continue block0;
                }
            }
            result.addAll(keys);
            return result;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            LinkedHashSet<Map.Entry<Object, Object>> entries = new LinkedHashSet<Map.Entry<Object, Object>>(super.entrySet());
            LinkedHashSet<Map.Entry<Object, Object>> result = new LinkedHashSet<Map.Entry<Object, Object>>();
            block0: for (String key : PROPERTIES) {
                for (Map.Entry entry : entries.toArray(new Map.Entry[0])) {
                    if (!entry.getKey().equals(key)) continue;
                    result.add(entry);
                    entries.remove(entry);
                    continue block0;
                }
            }
            result.addAll(entries);
            return result;
        }
    }
}

