/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.config;

import java.io.Console;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.system.common.crypto.KeyGenerator;
import org.openvpms.tool.toolbox.config.Config;
import org.openvpms.tool.toolbox.config.ConfigPropertiesUpdater;
import org.openvpms.tool.toolbox.config.ConsoleConfig;
import org.openvpms.tool.toolbox.config.DefaultConfig;
import org.openvpms.tool.toolbox.config.FallbackConfig;
import org.openvpms.tool.toolbox.util.PathHelper;

public class ConfigCreator {
    public void createDefault(Path path) throws IOException {
        DefaultConfig defaults = new DefaultConfig();
        ConfigPropertiesUpdater config = new ConfigPropertiesUpdater(path);
        this.generate(config, new FallbackConfig(config.getProperties(), defaults.getProperties()));
    }

    public void prompt(Path path) throws IOException {
        Console console = System.console();
        if (console == null) {
            throw new IOException("This command must be executed in a console");
        }
        DefaultConfig defaults = new DefaultConfig();
        ConfigPropertiesUpdater config = new ConfigPropertiesUpdater(path);
        ConsoleConfig consoleConfig = new ConsoleConfig(console, config.getProperties(), defaults.getProperties());
        this.generate(config, consoleConfig);
    }

    private void generate(ConfigPropertiesUpdater config, Config source) throws IOException {
        config.setDriver(source.getDriver());
        config.setUrl(source.getUrl());
        config.setUsername(source.getUsername());
        config.setPassword(source.getPassword());
        config.setReportingUrl(source.getReportingUrl());
        config.setReportingUsername(source.getReportingUsername());
        config.setReportingPassword(source.getReportingPassword());
        if (StringUtils.isEmpty((CharSequence)config.getKey())) {
            config.setKey(KeyGenerator.generate((int)14, (int)32));
        }
        if (config.isModified()) {
            config.write();
        }
        Path relative = PathHelper.getPathRelativeToCWD(config.getPath());
        try {
            config.setPermissions();
        }
        catch (Exception exception) {
            System.err.printf("\nThe file %s should have restrictive permissions to protect passwords\n", relative);
        }
        System.out.printf("\nTake a secure backup of the file %s\nThis needs to be kept for subsequent updates.\n\n", relative);
    }
}

