/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.archetype;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.tool.toolbox.util.PathHelper;
import org.openvpms.tools.archetype.loader.ArchetypeLoader;

public class ArchetypeLoadHelper {
    private final ArchetypeLoader loader;
    private boolean verbose = false;

    public ArchetypeLoadHelper(IArchetypeRuleService service) {
        this.loader = ArchetypeLoader.newBootstrapLoader((IArchetypeService)service);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void load(String file) {
        this.loader.setVerbose(this.verbose);
        this.loader.loadArchetypes(file);
    }

    public void loadAll(String dir) {
        this.loader.setVerbose(this.verbose);
        dir = PathHelper.replaceHome(dir);
        Path mappingFile = Paths.get(dir, "org/openvpms/archetype/assertionTypes.xml");
        this.loader.loadAssertions(mappingFile.toString());
        this.loader.loadArchetypes(dir, true);
    }
}

