/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.util.PathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public abstract class AbstractCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display this help message"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"--properties"}, description={"Specifies the path to openvpms.properties"}, hidden=true)
    private Path path;
    private static final Logger log = LoggerFactory.getLogger(AbstractCommand.class);

    public void setPath(Path path) {
        this.path = path;
    }

    @Override
    public Integer call() {
        int result;
        try {
            this.init();
            result = this.run();
        }
        catch (Throwable exception) {
            result = 1;
            System.err.println(exception.getMessage());
            log.error(exception.getMessage(), exception);
        }
        return result;
    }

    protected void init() throws Exception {
    }

    protected abstract int run() throws Exception;

    protected Path getPropertiesPath() {
        return this.path != null ? this.path : PathHelper.getHome().resolve("conf/openvpms.properties");
    }

    protected ConfigProperties loadProperties() throws IOException {
        return new ConfigProperties(this.getPropertiesPath());
    }

    protected void checkProperties(ConfigProperties properties) throws Exception {
        if (!properties.isComplete()) {
            Path relative = PathHelper.getPathRelativeToCWD(properties.getPath());
            if (!properties.exists()) {
                throw new Exception("The " + relative + " configuration does not exist.\nRun toolbox configure");
            }
            throw new Exception("The " + relative + " configuration is incomplete.\nRun toolbox configure");
        }
        properties.validate();
    }

    protected void checkDriver(ConfigProperties properties) {
        String driver = properties.getDriver();
        try {
            Class.forName(driver);
        }
        catch (Throwable exception) {
            Path lib = PathHelper.getPathRelativeToCWD(PathHelper.getHome().resolve("lib"));
            throw new IllegalStateException("The database driver " + driver + " cannot be found.\nCheck that the jar file exists and is readable in the " + lib + " directory");
        }
    }
}

