/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.war;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.tool.toolbox.util.PathHelper;
import org.openvpms.tool.toolbox.war.CopyPropertiesPatch;
import org.openvpms.tool.toolbox.war.Log4JPatch;
import org.openvpms.tool.toolbox.war.Patch;
import org.openvpms.tool.toolbox.war.WebXMLPatch;

public class WarBuilder {
    public static final String MASTER_ZIP_PATH = "${openvpms.home}/webapps/openvpms-master.zip";
    public static final String OUTPUT_DIR_PATH = "${openvpms.home}/webapps";

    public Path build(String name, Path properties) throws IOException {
        return this.build(name, OUTPUT_DIR_PATH, MASTER_ZIP_PATH, properties);
    }

    public Path build(String name, String dir, String archive, Path properties) throws IOException {
        dir = PathHelper.replaceHome(dir);
        archive = PathHelper.replaceHome(archive);
        Path tempJarFile = Files.createTempFile(Paths.get(dir, new String[0]), "openvpms", ".war", new FileAttribute[0]);
        Path result = Paths.get(dir, name + ".war");
        Map<String, Patch> patches = this.getPatches(name, properties);
        try (JarFile jar = new JarFile(archive);
             OutputStream out = Files.newOutputStream(tempJarFile, new OpenOption[0]);){
            JarStream tempJar = new JarStream(out);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                InputStream inputStream = jar.getInputStream(entry);
                Throwable throwable = null;
                try {
                    Patch patch = patches.remove(entry.getName());
                    if (patch == null) {
                        tempJar.putNextEntry(entry);
                        IOUtils.copy((InputStream)inputStream, (OutputStream)tempJar);
                    } else {
                        tempJar.putNextEntry(new JarEntry(entry.getName()));
                        patch.apply(inputStream, tempJar);
                    }
                    tempJar.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            tempJar.realClose();
            Files.move(tempJarFile, result, StandardCopyOption.REPLACE_EXISTING);
        }
        if (!patches.isEmpty()) {
            throw new IllegalStateException("Not all patches were applied: " + StringUtils.join(patches.keySet(), (String)", "));
        }
        return result;
    }

    protected Map<String, Patch> getPatches(String name, Path properties) {
        HashMap<String, Patch> result = new HashMap<String, Patch>();
        result.put("WEB-INF/classes/openvpms.properties", new CopyPropertiesPatch(properties));
        if (!"openvpms".equals(name)) {
            result.put("WEB-INF/web.xml", new WebXMLPatch(name));
            result.put("WEB-INF/classes/log4j2.xml", new Log4JPatch(name));
        }
        return result;
    }

    private static class JarStream
    extends JarOutputStream {
        public JarStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        public void close() {
        }

        public void realClose() throws IOException {
            super.close();
        }
    }
}

