/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

public class PathHelper {
    public static Path getPathRelativeToCWD(Path path) {
        Path cwd = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        return cwd.relativize(path);
    }

    public static Path getHome() {
        String home = System.getProperty("openvpms.home");
        if (home == null) {
            throw new IllegalStateException("openvpms.home is not defined");
        }
        Path path = Paths.get(home, new String[0]);
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalStateException("Invalid openvpms.home: " + path);
        }
        return path;
    }

    public static String replaceHome(String path) {
        return path.replace("${openvpms.home}", PathHelper.getHome().toString());
    }

    public static void restrictPermissions(Path path) throws IOException {
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rw-------");
        Files.setPosixFilePermissions(path, permissions);
    }
}

