/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.user;

import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.tool.toolbox.user.AbstractUserCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--set-email", description={"Sets the email address of a user"})
public class SetEmailCommand
extends AbstractUserCommand {
    @CommandLine.Parameters(index="0", arity="1")
    private String username;
    @CommandLine.Parameters(index="1", arity="1")
    private String email;

    @Override
    protected int run() {
        int result = -1;
        ArchetypeService service = (ArchetypeService)this.getBean(IArchetypeRuleService.class);
        Contacts contacts = new Contacts(service);
        User user = this.getUser(this.username);
        if (user != null) {
            String current = contacts.getEmail((Party)user);
            if (!this.email.equals(current)) {
                Contact contact = contacts.getEmailContact((Party)user);
                if (contact == null) {
                    contact = (Contact)service.create("contact.email", Contact.class);
                    contact.setName(user.getName());
                    user.addContact(contact);
                }
                IMObjectBean bean = service.getBean((IMObject)contact);
                bean.setValue("preferred", (Object)true);
                bean.setValue("emailAddress", (Object)this.email);
                bean.save();
            }
            result = 1;
        } else {
            System.err.println("User not found");
        }
        return result;
    }
}

