/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.user;

import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.tool.toolbox.user.AbstractRoleCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--remove-role", description={"Removes roles from a user"})
public class RemoveRoleCommand
extends AbstractRoleCommand {
    @CommandLine.Parameters(description={"The roles to remove"}, index="1..*", arity="1..*")
    String[] roles;

    @Override
    protected int updateUser(User user) {
        int result = 0;
        for (String name : this.roles) {
            if (this.removeRole(name, user)) continue;
            System.err.println("Role not found: " + name);
            result = 1;
            break;
        }
        if (result != 1) {
            this.save(user);
            System.out.println("User updated");
        }
        return result;
    }

    private boolean removeRole(String name, User user) {
        boolean result = false;
        for (SecurityRole role : user.getRoles().toArray(new SecurityRole[0])) {
            if (!name.equals(role.getName())) continue;
            user.removeRole(role);
            result = true;
        }
        return result;
    }
}

