/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.template;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.tools.TemplateLoader;
import org.openvpms.report.tools.Templates;
import org.openvpms.tool.toolbox.AbstractApplicationContextCommand;
import org.openvpms.tool.toolbox.util.PathHelper;
import org.springframework.transaction.PlatformTransactionManager;
import picocli.CommandLine;

@CommandLine.Command(name="--load")
public class LoadTemplateCommand
extends AbstractApplicationContextCommand {
    @CommandLine.ArgGroup(multiplicity="1")
    Type type;
    @CommandLine.ArgGroup(multiplicity="1")
    Options options;
    private final List<Templates> descriptors = new ArrayList<Templates>();

    @Override
    protected int run() throws Exception {
        TemplateLoader loader = new TemplateLoader((IArchetypeService)this.getBean(IArchetypeRuleService.class), this.getBean(DocumentHandlers.class), this.getBean(PlatformTransactionManager.class), this.getBean(LookupService.class));
        if (this.type.size != null) {
            this.loadBySize(this.type.size, loader);
        } else {
            this.loadFromFile(this.type.file, loader);
        }
        return 0;
    }

    private void loadBySize(Size size, TemplateLoader loader) throws JAXBException {
        HashMap<String, Entity> emailTemplates = new HashMap<String, Entity>();
        Set<String> templates = this.options.all ? new LinkedHashSet<String>(Arrays.asList("documents", "reports")) : this.getTemplates();
        for (String template : templates) {
            if (!this.isReportsOrDocuments(template) || this.exists(template, size)) continue;
            throw new IllegalArgumentException(template + " are not available in size " + (Object)((Object)size));
        }
        for (String template : templates) {
            if (this.isReportsOrDocuments(template)) {
                loader.load(this.getPath(template, size).toString(), emailTemplates);
                continue;
            }
            this.loadBySize(template, loader, size, emailTemplates);
        }
    }

    private void loadFromFile(String file, TemplateLoader loader) throws JAXBException {
        Path path = Paths.get(file, new String[0]);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalStateException("Cannot read " + path);
        }
        if (this.options.all) {
            loader.load(file);
        } else {
            Set<String> templates = this.getTemplates();
            Templates descriptors = loader.getTemplates(path.toFile());
            File dir = path.toFile().getParentFile();
            HashMap emailTemplates = new HashMap();
            for (String template : templates) {
                loader.load(template, descriptors, dir, emailTemplates);
            }
        }
    }

    private Set<String> getTemplates() {
        return new LinkedHashSet<String>(Arrays.asList(this.options.templates));
    }

    private void loadBySize(String template, TemplateLoader loader, Size size, Map<String, Entity> emailTemplates) throws JAXBException {
        if (this.descriptors.isEmpty()) {
            Path reports;
            Path documents = this.getPath("documents", size);
            if (Files.exists(documents, new LinkOption[0])) {
                this.descriptors.add(loader.getTemplates(documents.toFile()));
            }
            if (Files.exists(reports = this.getPath("reports", size), new LinkOption[0])) {
                this.descriptors.add(loader.getTemplates(reports.toFile()));
            }
        }
        if (this.descriptors.isEmpty()) {
            throw new IllegalStateException("Cannot find templates in " + (Object)((Object)size));
        }
        File dir = this.getReportsDir().toFile();
        boolean found = false;
        for (Templates templates : this.descriptors) {
            if (!loader.load(template, templates, dir, emailTemplates)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Template not found: " + template);
        }
    }

    private boolean isReportsOrDocuments(String template) {
        return "reports".equals(template) || "documents".equals(template);
    }

    private boolean exists(String descriptors, Size size) {
        Path path = this.getPath(descriptors, size);
        return Files.exists(path, new LinkOption[0]);
    }

    private Path getPath(String descriptors, Size size) {
        Path reports = this.getReportsDir();
        return reports.resolve(descriptors + "-" + (Object)((Object)size) + ".xml");
    }

    private Path getReportsDir() {
        return PathHelper.getHome().resolve("reports");
    }

    static enum Size {
        A4,
        A5,
        Letter;

    }

    static class Options {
        @CommandLine.Option(names={"-a", "--all"}, description={"Load all templates"})
        boolean all;
        @CommandLine.Parameters(description={"The templates to load"}, arity="1..*")
        String[] templates;

        Options() {
        }
    }

    static class Type {
        @CommandLine.Option(names={"-f", "--file"}, description={"Load templates from a file"})
        String file;
        @CommandLine.Option(names={"-s", "--size"}, description={"The template size. One of: ${COMPLETION-CANDIDATES}"})
        Size size;

        Type() {
        }
    }
}

