/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.ssl;

import java.io.InputStream;
import java.io.OutputStream;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.openvpms.tool.toolbox.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--check", description={"Check SSL connectivity"})
public class SSLCommand
extends AbstractCommand {
    @CommandLine.Parameters(index="0", arity="1")
    String host;
    @CommandLine.Parameters(index="1", arity="1")
    int port;
    @CommandLine.Option(names={"-n"}, description={"Number of calls to make"}, defaultValue="1")
    int count;

    @Override
    protected int run() throws Exception {
        if (this.count < 0) {
            this.count = 1;
        }
        int success = 0;
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        System.out.println("Connecting to " + this.host + " port " + this.port);
        for (int i = 0; i < this.count; ++i) {
            if (this.count > 1) {
                System.out.printf("%d... ", i + 1);
            }
            if (i > 0) {
                Thread.sleep(1000L);
            }
            try (SSLSocket socket = (SSLSocket)factory.createSocket(this.host, this.port);){
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                out.write(1);
                while (in.available() > 0) {
                    System.out.print(in.read());
                }
                System.out.println("Successfully connected");
                socket.close();
                ++success;
                continue;
            }
            catch (Throwable exception) {
                System.out.print("Failed: ");
                exception.printStackTrace();
            }
        }
        if (this.count > 1) {
            double percent = success > 0 ? (double)this.count * 100.0 / (double)success : 0.0;
            System.out.printf("%d of %d calls were successful (%.1f%%)\n", success, this.count, percent);
        }
        return success == this.count ? 0 : 1;
    }
}

