/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.firewall;

import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.tool.toolbox.firewall.AbstractFirewallCommand;
import org.openvpms.tool.toolbox.firewall.ListAllowedCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--show", description={"Displays the firewall configuration"})
public class ShowCommand
extends AbstractFirewallCommand {
    @Override
    protected int run() throws Exception {
        FirewallSettings settings = this.getSettings();
        FirewallSettings.AccessType type = settings.getAccessType();
        System.out.println("Access type: " + type);
        if (type == FirewallSettings.AccessType.UNRESTRICTED) {
            System.out.println("    Users can connect from anywhere");
        } else if (type == FirewallSettings.AccessType.ALLOWED_ONLY) {
            System.out.println("    Users can only connect from allowed addresses");
        } else {
            System.out.println("    Users can only connect from allowed addresses, unless they have 'Connect from Anywhere' set");
        }
        System.out.println("Allowed addresses:");
        ListAllowedCommand.showAllowedAddresses(settings);
        return 0;
    }
}

