/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.BaseFlywayCallback;
import org.flywaydb.core.internal.util.TimeFormat;
import org.slf4j.Logger;

public class FlywayLogger
extends BaseFlywayCallback {
    private final Logger log;
    private final boolean headless;
    private final Map<MigrationInfo, StopWatch> state = new HashMap<MigrationInfo, StopWatch>();

    public FlywayLogger(Logger log, boolean headless) {
        this.log = log;
        this.headless = headless;
    }

    public void beforeEachMigrate(Connection connection, MigrationInfo info) {
        StopWatch watch = new StopWatch();
        this.state.put(info, watch);
        if (info.getVersion() != null) {
            if (this.headless) {
                this.log.info("Updating to {} - {}", (Object)info.getVersion(), (Object)info.getDescription());
            } else {
                System.out.print("Updating to " + info.getVersion() + " - " + info.getDescription() + " ... ");
            }
        } else if (this.headless) {
            this.log.info("Running {} ", (Object)info.getDescription());
        } else {
            System.out.print("Running " + info.getDescription() + " ... ");
        }
        watch.start();
    }

    public void afterEachMigrate(Connection connection, MigrationInfo info) {
        StopWatch watch = this.state.get(info);
        if (watch != null) {
            watch.stop();
            String time = TimeFormat.format((long)watch.getTime());
            if (this.headless) {
                this.log.info("Completed {} in {}", (Object)info.getDescription(), (Object)time);
            } else {
                System.out.println(time);
            }
        }
    }
}

