/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import java.sql.SQLException;
import org.apache.commons.lang3.time.StopWatch;
import org.openvpms.component.business.dao.im.plugin.PluginDAO;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.db.service.ArchetypeMigrator;
import org.openvpms.db.service.DatabaseAdminService;
import org.openvpms.db.service.DbVersionInfo;
import org.openvpms.db.service.PluginMigrator;
import org.openvpms.tool.toolbox.archetype.ArchetypeLoadHelper;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.db.ContextLoader;
import org.openvpms.tool.toolbox.db.PluginMigratorImpl;
import org.openvpms.tool.toolbox.i18n.ToolboxMessages;
import org.openvpms.tools.archetype.loader.ArchetypeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUpdater {
    private final ConfigProperties properties;
    private final ContextLoader loader;
    private final DatabaseAdminService service;
    private static final PluginMigrator NO_OP_MIGRATOR = () -> {};
    private static final Logger log = LoggerFactory.getLogger(DatabaseUpdater.class);

    public DatabaseUpdater(ConfigProperties properties, ContextLoader loader, DatabaseAdminService service) {
        this.properties = properties;
        this.service = service;
        this.loader = loader;
    }

    public void update(String archetypesDir, String pluginsDir) throws SQLException {
        DbVersionInfo info = this.service.getVersionInfo();
        if (info.hasFutureVersion()) {
            throw new SQLException(ToolboxMessages.get("db.update.futurechanges", info.getFutureChanges()));
        }
        if (info.needsUpdate()) {
            this.doUpdate(archetypesDir, pluginsDir);
        } else {
            log.info("Database '{}' is up to date", (Object)this.service.getSchemaName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdate(String archetypesDir, String pluginsDir) throws SQLException {
        try {
            String version = this.service.getVersion();
            String schemaName = this.service.getSchemaName();
            String key = this.properties.getKey();
            System.setProperty("openvpms.key", key);
            ArchetypeMigrator migrator = () -> {
                IArchetypeRuleService service = (IArchetypeRuleService)this.loader.getContext().getBean(IArchetypeRuleService.class);
                ArchetypeLoadHelper helper = new ArchetypeLoadHelper(service);
                helper.setVerbose(LoggerFactory.getLogger(ArchetypeLoader.class).isDebugEnabled());
                helper.loadAll(archetypesDir);
            };
            PluginMigrator pluginMigrator = pluginsDir == null ? NO_OP_MIGRATOR : () -> {
                PluginDAO dao = (PluginDAO)this.loader.getContext().getBean(PluginDAO.class);
                PluginMigrator delegate = this.createPluginMigrator(dao, pluginsDir);
                delegate.migrate();
            };
            StopWatch stopWatch = StopWatch.createStarted();
            this.service.update(migrator, pluginMigrator);
            if (version == null) {
                log.info("Database '{}' updated to version {} in {}", new Object[]{schemaName, this.service.getVersion(), stopWatch});
            } else {
                log.info("Database '{}' updated from version {} to {} in {}", new Object[]{schemaName, version, this.service.getVersion(), stopWatch});
            }
        }
        finally {
            System.getProperties().remove("openvpms.key");
        }
    }

    protected PluginMigrator createPluginMigrator(PluginDAO dao, String pluginsDir) {
        return new PluginMigratorImpl(dao, pluginsDir);
    }
}

