/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.openvpms.db.service.DatabaseService;
import org.openvpms.tool.toolbox.db.AbstractDBCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="--size", header={"Displays the database size"})
public class DBSizeCommand
extends AbstractDBCommand {
    private static final Logger log = LoggerFactory.getLogger(DBSizeCommand.class);

    @Override
    protected int run() throws Exception {
        DatabaseService service = this.getDatabaseService();
        long size = service.getSize();
        String value = size / 0x280000000L > 0L ? this.getSize(size, 0x40000000L, "GB") : (size / 0x100000L > 0L ? this.getSize(size, 0x100000L, "MB") : (size / 1024L > 0L ? this.getSize(size, 1024L, "KB") : size + " bytes"));
        log.info(service.getSchemaName() + " " + value);
        return 0;
    }

    private String getSize(long size, long divisor, String suffix) {
        BigDecimal result = new BigDecimal(size).divide(BigDecimal.valueOf(divisor), 2, RoundingMode.CEILING);
        DecimalFormat format = new DecimalFormat("#,##.##");
        return format.format(result) + " " + suffix;
    }
}

