/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.DatabaseAdminService;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.db.AbstractAdminDBCommand;
import picocli.CommandLine;

@CommandLine.Command(name="--create", header={"Create the database"})
public class CreateDBCommand
extends AbstractAdminDBCommand {
    @CommandLine.Option(names={"--host"}, description={"Host users are connecting from"}, required=true, defaultValue="localhost", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String host;
    @CommandLine.Option(names={"--empty"}, description={"Create an empty database.\nUse this when restoring a backup to a new server."})
    private boolean empty;
    @CommandLine.Option(names={"-d", "--dir"}, description={"The archetype directory."}, defaultValue="${openvpms.home}/archetypes")
    private String dir = "${openvpms.home}/archetypes";

    @Override
    protected int run() throws Exception {
        int result;
        DatabaseAdminService service = this.getAdminService();
        ConfigProperties properties = this.getProperties();
        service.create(new Credentials(properties.getUsername(), properties.getPassword()), new Credentials(properties.getReportingUsername(), properties.getReportingPassword()), this.host, !this.empty);
        if (!this.empty) {
            this.updateDatabase(this.dir, null);
            result = 0;
        } else {
            result = 0;
        }
        return result;
    }
}

