/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import java.io.File;
import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.DatabaseService;
import org.openvpms.db.service.impl.DatabaseServiceImpl;
import org.openvpms.tool.toolbox.AbstractCommand;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.util.PathHelper;

public abstract class AbstractDBCommand
extends AbstractCommand {
    private ConfigProperties properties;
    private DatabaseService service;

    @Override
    protected void init() throws Exception {
        this.properties = this.loadProperties();
        this.checkProperties(this.properties);
        this.checkDriver(this.properties);
    }

    protected ConfigProperties getProperties() {
        return this.properties;
    }

    protected DatabaseService getDatabaseService() {
        if (this.service == null) {
            ConfigProperties properties = this.getProperties();
            Credentials user = new Credentials(properties.getUsername(), properties.getPassword());
            this.service = new DatabaseServiceImpl(properties.getDriver(), properties.getUrl(), user);
        }
        return this.service;
    }

    protected String getDir(String dir, String argument) {
        if (!new File(dir = PathHelper.replaceHome(dir)).isDirectory()) {
            throw new IllegalStateException("Argument " + argument + " is not a valid directory");
        }
        return dir;
    }
}

