/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.db;

import java.sql.SQLException;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.DatabaseAdminService;
import org.openvpms.db.service.impl.DatabaseAdminServiceImpl;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.db.AbstractDBCommand;
import org.openvpms.tool.toolbox.db.ContextLoader;
import org.openvpms.tool.toolbox.db.DatabaseUpdater;
import org.openvpms.tool.toolbox.db.FlywayLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public abstract class AbstractAdminDBCommand
extends AbstractDBCommand {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @CommandLine.Option(names={"-u"}, required=true, description={"Database administrator user name"})
    private String user;
    @CommandLine.Option(names={"-p"}, required=true, description={"Database administrator password"}, interactive=true, arity="0..1")
    private String password;
    private DatabaseAdminService adminService;

    protected AbstractAdminDBCommand() {
    }

    @Override
    protected void init() throws Exception {
        super.init();
        ConfigProperties properties = this.getProperties();
        this.adminService = new DatabaseAdminServiceImpl(properties.getDriver(), properties.getUrl(), new Credentials(this.user, this.password), (FlywayCallback)new FlywayLogger(this.log, false));
    }

    protected DatabaseAdminService getAdminService() {
        return this.adminService;
    }

    protected void updateDatabase(String archetypesDir, String pluginsDir) throws SQLException {
        ConfigProperties properties = this.getProperties();
        ContextLoader loader = new ContextLoader(properties.getDriver(), properties.getUrl(), this.user, this.password);
        DatabaseUpdater updater = new DatabaseUpdater(properties, loader, this.adminService);
        updater.update(archetypesDir, pluginsDir);
    }
}

