/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.config;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;

public class PasswordGenerator {
    private final Random random = new SecureRandom();
    static final String UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final String LOWER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase();
    static final String NUMERIC = "0123456789";
    static final String SPECIAL = ":@.,/+-=";
    static final String ALL = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + LOWER + "0123456789" + ":@.,/+-=";

    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.generate(UPPER, 2));
        builder.append(this.generate(LOWER, 2));
        builder.append(this.generate(NUMERIC, 2));
        builder.append(this.generate(SPECIAL, 2));
        int remaining = this.random.nextInt(16 - builder.length());
        if (remaining != 0) {
            builder.append(this.generate(ALL, remaining));
        }
        char[] chars = builder.toString().toCharArray();
        ArrayUtils.shuffle((char[])chars, (Random)this.random);
        return String.valueOf(chars);
    }

    private String generate(String characters, int length) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result.append(characters.charAt(this.random.nextInt(characters.length())));
        }
        return result.toString();
    }
}

