/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.config;

import java.util.Properties;
import org.openvpms.tool.toolbox.config.Config;

class FallbackConfig
implements Config {
    private final Properties properties;
    private final Properties fallback;

    public FallbackConfig(Properties properties, Properties fallback) {
        this.properties = properties;
        this.fallback = fallback;
    }

    @Override
    public String getDriver() {
        return this.getProperty("db.driver");
    }

    @Override
    public String getUrl() {
        return this.getProperty("db.url");
    }

    @Override
    public String getUsername() {
        return this.getProperty("db.username");
    }

    @Override
    public String getPassword() {
        return this.getProperty("db.password");
    }

    @Override
    public String getReportingUrl() {
        String value = this.properties.getProperty("reporting.db.url");
        return value != null ? value : this.properties.getProperty("db.url");
    }

    @Override
    public String getReportingUsername() {
        return this.getProperty("reporting.db.username");
    }

    @Override
    public String getReportingPassword() {
        return this.getProperty("reporting.db.password");
    }

    @Override
    public String getKey() {
        return this.getProperty("openvpms.key");
    }

    private String getProperty(String key) {
        String value = this.properties.getProperty(key);
        return value != null ? value : this.fallback.getProperty(key);
    }
}

