/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.archetype;

import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.tool.toolbox.AbstractApplicationContextCommand;
import org.openvpms.tool.toolbox.archetype.ArchetypeLoadHelper;
import picocli.CommandLine;

@CommandLine.Command(name="--load", description={"Load archetypes"})
public class ArchetypeLoadCommand
extends AbstractApplicationContextCommand {
    @CommandLine.Option(names={"-d", "--dir"}, description={"The archetype directory."}, defaultValue="${openvpms.home}/archetypes")
    String dir = "${openvpms.home}/archetypes";
    @CommandLine.Option(names={"-f", "--file"}, description={"Used to load a single file."})
    String file;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Displays verbose info to the console."})
    boolean verbose;
    public static final String DEFAULT_PATH = "${openvpms.home}/archetypes";

    @Override
    protected int run() {
        ArchetypeLoadHelper helper = new ArchetypeLoadHelper(this.getBean(IArchetypeRuleService.class));
        helper.setVerbose(this.verbose);
        if (this.file != null) {
            helper.load(this.file);
        } else {
            helper.loadAll(this.dir);
        }
        System.out.println("Archetypes successfully loaded");
        return 0;
    }
}

