/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox;

import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.openvpms.db.service.DatabaseService;
import org.openvpms.db.service.DatabaseVersionChecker;
import org.openvpms.db.service.DbVersionInfo;
import org.openvpms.tool.toolbox.AbstractCommand;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.db.ContextLoader;
import org.openvpms.tool.toolbox.util.PathHelper;
import org.springframework.context.ApplicationContext;

public abstract class AbstractApplicationContextCommand
extends AbstractCommand {
    private final boolean ignoreDatabaseVersion;
    private ApplicationContext context;
    private ConfigProperties properties;

    public AbstractApplicationContextCommand() {
        this(false);
    }

    public AbstractApplicationContextCommand(boolean ignoreDatabaseVersion) {
        this.ignoreDatabaseVersion = ignoreDatabaseVersion;
    }

    protected <T> T getBean(Class<T> type) {
        return (T)this.getContext().getBean(type);
    }

    @Override
    protected void init() throws Exception {
        this.properties = this.loadProperties();
        this.checkProperties(this.properties);
        this.checkDriver(this.properties);
        this.checkDatabaseConnection();
        this.checkDatabaseVersion();
    }

    private void checkDatabaseConnection() {
        try {
            Connection connection = DriverManager.getConnection(this.properties.getUrl(), this.properties.getUsername(), this.properties.getPassword());
            Throwable throwable = null;
            if (connection != null) {
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    connection.close();
                }
            }
        }
        catch (SQLException exception) {
            Path path = PathHelper.getPathRelativeToCWD(this.properties.getPath());
            throw new IllegalStateException("Failed to connect to the database: " + exception.getMessage() + "\nVerify the details in " + path + " are correct");
        }
    }

    private void checkDatabaseVersion() throws SQLException {
        DatabaseService service = (DatabaseService)this.getContext().getBean(DatabaseService.class);
        if (!this.ignoreDatabaseVersion) {
            DatabaseVersionChecker versionChecker = new DatabaseVersionChecker();
            versionChecker.check(service);
        } else {
            DbVersionInfo versionInfo = service.getVersionInfo();
            if (versionInfo.needsUpdate() || versionInfo.hasFutureVersion()) {
                System.err.println("WARNING: the database needs to be updated");
            }
        }
    }

    private ApplicationContext getContext() {
        if (this.context == null) {
            this.context = new ContextLoader(this.properties).getContext();
        }
        return this.context;
    }
}

