/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.user;

import java.util.List;
import org.openvpms.archetype.rules.user.PasswordValidator;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.tool.toolbox.user.AbstractUserCommand;
import org.springframework.security.crypto.password.PasswordEncoder;
import picocli.CommandLine;

@CommandLine.Command(name="--set-password", aliases={"--setpassword"}, description={"Sets a user's password"})
public class UserPasswordCommand
extends AbstractUserCommand {
    @CommandLine.Parameters(index="0", arity="1")
    String user;
    @CommandLine.Option(names={"-p"}, description={"password"}, required=true, interactive=true, arity="0..1")
    String password;

    @Override
    protected int run() {
        int result;
        User match = this.getUser(this.user);
        if (match != null) {
            PasswordValidator validator = this.getBean(PasswordValidator.class);
            List errors = validator.validate(this.password);
            if (!errors.isEmpty()) {
                System.err.println("Password not changed:");
                for (String error : errors) {
                    System.err.println("  " + error);
                }
                result = 1;
            } else {
                PasswordEncoder encoder = this.getBean(PasswordEncoder.class);
                String encrypted = encoder.encode((CharSequence)this.password);
                match.setPassword(encrypted);
                this.save(match);
                result = 0;
                System.err.println("Password updated");
            }
        } else {
            result = 1;
            System.err.println("User not found");
        }
        return result;
    }
}

