/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tool.toolbox.config;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import org.openvpms.tool.toolbox.config.ConfigProperties;
import org.openvpms.tool.toolbox.util.PathHelper;

public class ConfigPropertiesUpdater
extends ConfigProperties {
    private boolean changed;

    public ConfigPropertiesUpdater(Path path) throws IOException {
        super(path);
    }

    public void setDriver(String driver) {
        this.set("db.driver", driver);
    }

    public void setUrl(String url) {
        this.set("db.url", url);
    }

    public void setUsername(String username) {
        this.set("db.username", username);
    }

    public void setPassword(String password) {
        this.set("db.password", password);
    }

    public void setReportingUrl(String url) {
        this.set("reporting.db.url", url);
    }

    public void setReportingUsername(String username) {
        this.set("reporting.db.username", username);
    }

    public void setReportingPassword(String password) {
        this.set("reporting.db.password", password);
    }

    public void setKey(String key) {
        this.set("openvpms.key", key);
    }

    public boolean isModified() {
        return this.changed;
    }

    public void write() throws IOException {
        try (FileOutputStream stream = new FileOutputStream(this.getPath().toFile());){
            this.getProperties().store(stream, "WARNING: This file must be kept secure!");
        }
    }

    public void setPermissions() throws Exception {
        PathHelper.restrictPermissions(this.getPath());
    }

    @Override
    protected boolean set(String name, String value) {
        boolean result = super.set(name, value);
        this.changed |= result;
        return result;
    }
}

