/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2022 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.tool.toolbox.user;

import picocli.CommandLine;
import picocli.CommandLine.Command;

/**
 * A command to enable a user, by setting their active flag true.
 *
 * @author Tim Anderson
 */
@Command(name = "--enable", description = "Enables a user")
public class EnableUserCommand extends AbstractUserCommand {

    /**
     * The user name.
     */
    @CommandLine.Parameters(index = "0", arity = "1")
    private String user;

    /**
     * Runs the command.
     *
     * @return {@code 0} indicates success, non-zero failure
     */
    @Override
    protected int run() {
        return setActive(user, true) ? 0 : 1;
    }
}