/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tilldrawer.internal.service;

import org.openvpms.domain.till.Till;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.tilldrawer.exception.TillDrawerException;
import org.openvpms.tilldrawer.internal.i18n.TillDrawerMessages;
import org.openvpms.tilldrawer.internal.service.DefaultTillDrawerService;
import org.openvpms.tilldrawer.service.TillDrawerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TillDrawerServices
implements TillDrawerService {
    private final PluginManager pluginManager;
    private final TillDrawerService defaultService;
    private static final Logger log = LoggerFactory.getLogger(TillDrawerServices.class);

    public TillDrawerServices(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.defaultService = new DefaultTillDrawerService();
    }

    public String getName() {
        return "Till Drawer Services";
    }

    public boolean canOpen(Till till) {
        return this.getService(till) != null;
    }

    public void open(Till till) {
        TillDrawerService service = this.getService(till);
        if (service == null) {
            throw new TillDrawerException(TillDrawerMessages.noServiceToOpenDrawer());
        }
        service.open(till);
    }

    public TillDrawerService getService(Till till) {
        TillDrawerService result = null;
        if (this.pluginManager != null) {
            for (TillDrawerService service : this.pluginManager.getServices(TillDrawerService.class)) {
                if (!this.canOpen(service, till)) continue;
                result = service;
                break;
            }
        }
        if (result == null && this.canOpen(this.defaultService, till)) {
            result = this.defaultService;
        }
        return result;
    }

    private boolean canOpen(TillDrawerService service, Till till) {
        boolean result = false;
        try {
            result = service.canOpen(till);
        }
        catch (Exception exception) {
            log.warn("Failed to determine if TillDrawerService '{}' can open till '{}': {}", new Object[]{service.getName(), till.getName(), exception.getMessage(), exception});
        }
        return result;
    }
}

