/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tilldrawer.internal.service;

import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.openvpms.domain.till.DrawerCommand;
import org.openvpms.domain.till.Till;
import org.openvpms.tilldrawer.exception.TillDrawerException;
import org.openvpms.tilldrawer.internal.i18n.TillDrawerMessages;
import org.openvpms.tilldrawer.service.TillDrawerService;

public class DefaultTillDrawerService
implements TillDrawerService {
    public String getName() {
        return "Default Till Drawer Service";
    }

    public boolean canOpen(Till till) {
        DrawerCommand command = till.getDrawerCommand();
        return command != null && command.getPrinterServiceArchetype() == null;
    }

    public void open(Till till) {
        DrawerCommand command = till.getDrawerCommand();
        if (command == null || command.getCommand().length == 0) {
            throw new TillDrawerException(TillDrawerMessages.noDrawerCommand());
        }
        String printer = command.getPrinter();
        PrintService printService = this.getPrintService(printer);
        if (printService == null) {
            throw new TillDrawerException(TillDrawerMessages.printerNotFound(printer));
        }
        DocPrintJob job = printService.createPrintJob();
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        try {
            SimpleDoc doc = new SimpleDoc(command.getCommand(), flavor, null);
            job.print(doc, null);
        }
        catch (PrintException exception) {
            throw new TillDrawerException(TillDrawerMessages.openFailed(printer, exception.getMessage()), (Throwable)exception);
        }
    }

    private PrintService getPrintService(String printer) {
        HashPrintServiceAttributeSet attrSet = new HashPrintServiceAttributeSet(new PrinterName(printer, null));
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, attrSet);
        return printServices.length > 0 ? printServices[0] : null;
    }
}

