/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.test.service;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.plugin.service.archetype.ArchetypeInstaller;
import org.openvpms.sms.message.InboundMessageBuilder;
import org.openvpms.sms.message.Messages;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.service.SMSProvider;

public class TestSMSProvider
implements SMSProvider {
    private final ArchetypeService service;
    private final Messages messages;
    private final ScheduledExecutorService executorService;
    private static final String ARCHETYPE = "entity.smsProviderTest";
    private static final String REPLY_TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum";

    public TestSMSProvider(ArchetypeService service, Messages messages, ArchetypeInstaller installer) {
        this.service = service;
        this.messages = messages;
        installer.install(this.getClass(), "/org/openvpms/sms/test/internal/archetype/entity.smsProviderTest.adl");
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public String getName() {
        return "Test SMS Provider";
    }

    public String[] getArchetypes() {
        return new String[]{ARCHETYPE};
    }

    public void send(OutboundMessage message, Entity config) {
        IMObjectBean bean = this.service.getBean((IMObject)config);
        String text = message.getMessage();
        message.setStatus(OutboundMessage.Status.SENT);
        if (this.contains(text, bean.getString("replyYesToMessagesContaining"))) {
            this.scheduleReply(message, "YES", bean);
        } else if (this.contains(text, bean.getString("replyNoToMessagesContaining"))) {
            this.scheduleReply(message, "NO", bean);
        } else {
            String reply = bean.getBoolean("replyWithRandomText") ? this.generateText() : bean.getString("replyWithText");
            if (reply != null) {
                String count = bean.getString("replyCount", "1");
                int max = count.equals("1_TO_3") ? RandomUtils.nextInt((int)1, (int)4) : NumberUtils.toInt((String)count);
                for (int i = 1; i <= max; ++i) {
                    this.scheduleReply(message, reply, bean);
                }
            }
        }
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    private String generateText() {
        int length = RandomUtils.nextInt((int)17, (int)420);
        if (length > REPLY_TEXT.length()) {
            length = REPLY_TEXT.length();
        }
        return REPLY_TEXT.substring(0, length);
    }

    private void scheduleReply(OutboundMessage message, String text, IMObjectBean config) {
        int delay = config.getInt("replyDelay");
        this.executorService.schedule(() -> this.reply(message, text), (long)delay, TimeUnit.SECONDS);
    }

    private void reply(OutboundMessage message, String text) {
        ((InboundMessageBuilder)((InboundMessageBuilder)((InboundMessageBuilder)this.messages.getInboundMessageBuilder().phone("12345678")).message(text)).location((Party)message.getLocation())).outboundId(message.getId()).build();
    }

    private boolean contains(String message, String regexp) {
        return regexp != null && message.replace('\n', ' ').matches(regexp);
    }
}

