/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.service;

import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.sms.internal.message.MessagesImpl;
import org.openvpms.sms.internal.service.OutboundSMSDispatcher;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.service.SMSProvider;
import org.openvpms.sms.service.SMSService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SMSServiceImpl
extends MessagesImpl
implements SMSService,
InitializingBean,
DisposableBean {
    private final OutboundSMSDispatcher dispatcher;

    public SMSServiceImpl(IArchetypeRuleService service, PracticeService practiceService, PluginManager pluginManager, DomainService domainService, SMSProvider mailProvider) {
        super((ArchetypeService)service, domainService);
        this.dispatcher = new OutboundSMSDispatcher((ArchetypeService)service, pluginManager, practiceService, domainService, mailProvider);
    }

    public boolean isEnabled() {
        Entity config = this.dispatcher.getConfig();
        return config != null && config.isActive();
    }

    public int getMaxParts() {
        IMObjectBean bean = this.dispatcher.getConfigBean();
        return bean != null ? bean.getInt("parts") : 1;
    }

    public void send(OutboundMessage message) {
        this.dispatcher.queue(message);
    }

    public void afterPropertiesSet() {
        this.dispatcher.initialise();
    }

    public void destroy() throws Exception {
        this.dispatcher.destroy();
    }
}

