/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.sms.internal.service;

public class SMSLengthCalculator {
    public static final char[][] GSM_TO_UNICODE = new char[][]{{'\u0000', '@'}, {'\u0000', '\u0000'}, {'\u0001', '\u00a3'}, {'\u0002', '$'}, {'\u0003', '\u00a5'}, {'\u0004', '\u00e8'}, {'\u0005', '\u00e9'}, {'\u0006', '\u00f9'}, {'\u0007', '\u00ec'}, {'\b', '\u00f2'}, {'\t', '\u00e7'}, {'\t', '\u00c7'}, {'\n', '\n'}, {'\u000b', '\u00d8'}, {'\f', '\u00f8'}, {'\r', '\r'}, {'\u000e', '\u00c5'}, {'\u000f', '\u00e5'}, {'\u0010', '\u0394'}, {'\u0011', '_'}, {'\u0012', '\u03a6'}, {'\u0013', '\u0393'}, {'\u0014', '\u039b'}, {'\u0015', '\u03a9'}, {'\u0016', '\u03a0'}, {'\u0017', '\u03a8'}, {'\u0018', '\u03a3'}, {'\u0019', '\u0398'}, {'\u001a', '\u039e'}, {'\u001b', '\u00a0'}, {'\u1b0a', '\f'}, {'\u1b14', '^'}, {'\u1b28', '{'}, {'\u1b29', '}'}, {'\u1b2f', '\\'}, {'\u1b3c', '['}, {'\u1b3d', '~'}, {'\u1b3e', ']'}, {'\u1b40', '|'}, {'\u1b65', '\u20ac'}, {'\u001c', '\u00c6'}, {'\u001d', '\u00e6'}, {'\u001e', '\u00df'}, {'\u001f', '\u00c9'}, {' ', ' '}, {'!', '!'}, {'\"', '\"'}, {'#', '#'}, {'$', '\u00a4'}, {'%', '%'}, {'&', '&'}, {'\'', '\''}, {'(', '('}, {')', ')'}, {'*', '*'}, {'+', '+'}, {',', ','}, {'-', '-'}, {'.', '.'}, {'/', '/'}, {'0', '0'}, {'1', '1'}, {'2', '2'}, {'3', '3'}, {'4', '4'}, {'5', '5'}, {'6', '6'}, {'7', '7'}, {'8', '8'}, {'9', '9'}, {':', ':'}, {';', ';'}, {'<', '<'}, {'=', '='}, {'>', '>'}, {'?', '?'}, {'@', '\u00a1'}, {'A', 'A'}, {'A', '\u0391'}, {'B', 'B'}, {'B', '\u0392'}, {'C', 'C'}, {'D', 'D'}, {'E', 'E'}, {'E', '\u0395'}, {'F', 'F'}, {'G', 'G'}, {'H', 'H'}, {'H', '\u0397'}, {'I', 'I'}, {'I', '\u0399'}, {'J', 'J'}, {'K', 'K'}, {'K', '\u039a'}, {'L', 'L'}, {'M', 'M'}, {'M', '\u039c'}, {'N', 'N'}, {'N', '\u039d'}, {'O', 'O'}, {'O', '\u039f'}, {'P', 'P'}, {'P', '\u03a1'}, {'Q', 'Q'}, {'R', 'R'}, {'S', 'S'}, {'T', 'T'}, {'T', '\u03a4'}, {'U', 'U'}, {'V', 'V'}, {'W', 'W'}, {'X', 'X'}, {'X', '\u03a7'}, {'Y', 'Y'}, {'Y', '\u03a5'}, {'Z', 'Z'}, {'Z', '\u0396'}, {'[', '\u00c4'}, {'\\', '\u00d6'}, {']', '\u00d1'}, {'^', '\u00dc'}, {'_', '\u00a7'}, {'`', '\u00bf'}, {'a', 'a'}, {'b', 'b'}, {'c', 'c'}, {'d', 'd'}, {'e', 'e'}, {'f', 'f'}, {'g', 'g'}, {'h', 'h'}, {'i', 'i'}, {'j', 'j'}, {'k', 'k'}, {'l', 'l'}, {'m', 'm'}, {'n', 'n'}, {'o', 'o'}, {'p', 'p'}, {'q', 'q'}, {'r', 'r'}, {'s', 's'}, {'t', 't'}, {'u', 'u'}, {'v', 'v'}, {'w', 'w'}, {'x', 'x'}, {'y', 'y'}, {'z', 'z'}, {'{', '\u00e4'}, {'|', '\u00f6'}, {'}', '\u00f1'}, {'~', '\u00fc'}, {'\u007f', '\u00e0'}};
    public static final int SINGLE_PART_GSM_LENGTH = 160;
    public static final int MULTI_PART_GSM_LENGTH = 153;
    public static final int SINGLE_PART_UNICODE_LENGTH = 70;
    public static final int MULTI_PART_UNICODE_LENGTH = 67;

    public static int getGSMLength(String message) {
        int length = 0;
        for (char ch : message.toCharArray()) {
            int gsm = SMSLengthCalculator.getGSM(ch);
            if (gsm >= 0) {
                ++length;
                if (gsm <= 127) continue;
                ++length;
                continue;
            }
            length = -1;
            break;
        }
        return length;
    }

    public static int getParts(String message) {
        int parts;
        int length = SMSLengthCalculator.getGSMLength(message);
        if (length == -1) {
            length = message.length();
            parts = SMSLengthCalculator.getParts(length, 70, 67);
        } else {
            parts = SMSLengthCalculator.getParts(length, 160, 153);
        }
        return parts;
    }

    public static int getMaxLength(int maxParts, String message) {
        return SMSLengthCalculator.getMaxLength(maxParts, SMSLengthCalculator.getGSMLength(message) != -1);
    }

    public static int getMaxLength(int parts, boolean isGSM) {
        return isGSM ? SMSLengthCalculator.getMaxLength(parts, 160, 153) : SMSLengthCalculator.getMaxLength(parts, 70, 67);
    }

    private static int getMaxLength(int parts, int singlePartLength, int multiPartLength) {
        if (parts <= 1) {
            return singlePartLength;
        }
        return multiPartLength * parts;
    }

    private static int getParts(int length, int singlePartLength, int multiPartLength) {
        int parts;
        if (length > singlePartLength) {
            parts = length / multiPartLength;
            if (length % multiPartLength > 0) {
                ++parts;
            }
        } else {
            parts = 1;
        }
        return parts;
    }

    private static int getGSM(char ch) {
        for (char[] mapping : GSM_TO_UNICODE) {
            if (mapping[1] != ch) continue;
            return mapping[0];
        }
        return -1;
    }
}

